// XISLGotoTag.cpp: CXISLGotoTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLGotoTag.h"
#include "XISLDialogTag.h"
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLGotoTag::CXISLGotoTag()
{
	m_nTagType = ID_TAG_GOTO;
	m_nBmpID = IDB_GOTO;

	m_pGotoDialog = NULL;
	m_pParentTag = NULL;
}

CXISLGotoTag::~CXISLGotoTag()
{

}

CXISLGotoTag::CXISLGotoTag(const CXISLGotoTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pGotoDialog = cpXISL.m_pGotoDialog;
	POSITION pos = cpXISL.m_slNameList.GetHeadPosition();
	while(pos)
		m_slNameList.AddTail(cpXISL.m_slNameList.GetNext(pos));
}

CXISLGotoTag& CXISLGotoTag::operator=(const CXISLGotoTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pGotoDialog = cpXISL.m_pGotoDialog;
		POSITION pos = cpXISL.m_slNameList.GetHeadPosition();
		while(pos)
			m_slNameList.AddTail(cpXISL.m_slNameList.GetNext(pos));
	}
	return *this;
}

LPCTSTR CXISLGotoTag::GetXISLString()
{
	CString strTemp;
	CString strNext = m_pGotoDialog->GetDocName();
	strNext += "#";
	strNext += m_pGotoDialog->GetDialogID();
	m_strXISL = "<goto next = \"";
	m_strXISL += strNext;
	m_strXISL += "\" namelist = \"";
	GetNameList(strTemp);
	m_strXISL += strTemp;
	m_strXISL += "\"/>\r\n";

	return m_strXISL;
}

//BOOL CXISLGotoTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLGotoTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_GOTO];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

int CXISLGotoTag::SetGotoAttribute(CXISLDialogTag *pDTag,LPCTSTR lpszNameList)
{
	m_pGotoDialog = pDTag;
	m_slNameList.RemoveAll();

	CString strTemp = lpszNameList;
	if(!strTemp.IsEmpty())
	{
		int nIndex = 0;
		while(1)
		{
			nIndex = strTemp.Find(",");
			if(nIndex == -1)
			{
				m_slNameList.AddTail(strTemp);
				break;
			}
			if(nIndex != 0)
				m_slNameList.AddTail(strTemp.Left(nIndex));
			strTemp.Delete(0,nIndex+1);
		}
	}
	
	int nCount = m_pGotoDialog->GetDialogArgCount();
	if( nCount != m_slNameList.GetCount() )
	{
		m_pGotoDialog = NULL;
		m_slNameList.RemoveAll();
		return -1;
	}
	else
		return 0;
}

void CXISLGotoTag::GetNameList(CString &strName)
{
	POSITION pos = m_slNameList.GetHeadPosition();
	while(pos)
	{
		strName += m_slNameList.GetNext(pos);
		strName += ",";
	}
	strName.Delete(strName.GetLength()-1);
}
